/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.arithmetic;

import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.arithmetic.engine.InvalidOperatorException;
import at.petrak.hexcasting.api.casting.arithmetic.operator.Operator;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorBinary;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorUnary;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.casting.arithmetic.DoubleArithmetic;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.List;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00070\u00070\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00070\u00070\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lat/petrak/hexcasting/common/casting/arithmetic/BitwiseSetArithmetic;", "Lat/petrak/hexcasting/api/casting/arithmetic/Arithmetic;", "<init>", "()V", "", "arithName", "()Ljava/lang/String;", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "pattern", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/Operator;", "getOperator", "(Lat/petrak/hexcasting/api/casting/math/HexPattern;)Lat/petrak/hexcasting/api/casting/arithmetic/operator/Operator;", "Ljava/util/function/LongUnaryOperator;", "op", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorUnary;", "make1", "(Ljava/util/function/LongUnaryOperator;)Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorUnary;", "Ljava/util/function/LongBinaryOperator;", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorBinary;", "make2", "(Ljava/util/function/LongBinaryOperator;)Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorBinary;", "", "kotlin.jvm.PlatformType", "opTypes", "()Ljava/util/List;", "OPS", "Ljava/util/List;", "hexcasting-fabric-1.20.1"})
public final class BitwiseSetArithmetic
implements Arithmetic {
    @NotNull
    public static final BitwiseSetArithmetic INSTANCE = new BitwiseSetArithmetic();
    @NotNull
    private static final List<HexPattern> OPS;

    private BitwiseSetArithmetic() {
    }

    @Override
    @NotNull
    public String arithName() {
        return "bitwise_set_ops";
    }

    @NotNull
    public List<HexPattern> opTypes() {
        return OPS;
    }

    @Override
    @NotNull
    public Operator getOperator(@NotNull HexPattern pattern) {
        Operator operator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        HexPattern hexPattern = pattern;
        if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.AND)) {
            operator = this.make2(BitwiseSetArithmetic::getOperator$lambda$0);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.OR)) {
            operator = this.make2(BitwiseSetArithmetic::getOperator$lambda$1);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.XOR)) {
            operator = this.make2(BitwiseSetArithmetic::getOperator$lambda$2);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.NOT)) {
            operator = this.make1(BitwiseSetArithmetic::getOperator$lambda$3);
        } else {
            throw new InvalidOperatorException(pattern + " is not a valid operator in Arithmetic " + this + ".");
        }
        return operator;
    }

    private final OperatorUnary make1(LongUnaryOperator op) {
        return new OperatorUnary(DoubleArithmetic.INSTANCE.getACCEPTS(), arg_0 -> BitwiseSetArithmetic.make1$lambda$4(op, arg_0));
    }

    private final OperatorBinary make2(LongBinaryOperator op) {
        return new OperatorBinary(DoubleArithmetic.INSTANCE.getACCEPTS(), (arg_0, arg_1) -> BitwiseSetArithmetic.make2$lambda$5(op, arg_0, arg_1));
    }

    private static final long getOperator$lambda$0(long x, long y) {
        return x & y;
    }

    private static final long getOperator$lambda$1(long x, long y) {
        return x | y;
    }

    private static final long getOperator$lambda$2(long x, long y) {
        return x ^ y;
    }

    private static final long getOperator$lambda$3(long x) {
        return x ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static final Iota make1$lambda$4(LongUnaryOperator $op, Iota i) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        IotaType<DoubleIota> iotaType = HexIotaTypes.DOUBLE;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"DOUBLE");
        return new DoubleIota($op.applyAsLong(MathKt.roundToLong((double)Operator.Companion.downcast(i, iotaType).getDouble())));
    }

    private static final Iota make2$lambda$5(LongBinaryOperator $op, Iota i, Iota j) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)j, (String)"j");
        IotaType<DoubleIota> iotaType = HexIotaTypes.DOUBLE;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"DOUBLE");
        long l = MathKt.roundToLong((double)Operator.Companion.downcast(i, iotaType).getDouble());
        IotaType<DoubleIota> iotaType2 = HexIotaTypes.DOUBLE;
        Intrinsics.checkNotNullExpressionValue(iotaType2, (String)"DOUBLE");
        return new DoubleIota($op.applyAsLong(l, MathKt.roundToLong((double)Operator.Companion.downcast(j, iotaType2).getDouble())));
    }

    static {
        Object[] objectArray = new HexPattern[]{Arithmetic.AND, Arithmetic.OR, Arithmetic.XOR, Arithmetic.NOT};
        OPS = CollectionsKt.listOf((Object[])objectArray);
    }
}

